/*
 * Decompiled with CFR 0.152.
 */
package com.floragunn.searchguard.enterprise.dlsfls.legacy;

import com.floragunn.searchguard.queries.QueryBuilderTraverser;
import com.google.common.cache.Cache;
import com.google.common.cache.CacheBuilder;
import com.google.common.util.concurrent.UncheckedExecutionException;
import java.util.Set;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.TimeUnit;
import java.util.function.Function;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.apache.lucene.index.Term;
import org.apache.lucene.search.BooleanClause;
import org.apache.lucene.search.BooleanQuery;
import org.apache.lucene.search.MatchAllDocsQuery;
import org.apache.lucene.search.PrefixQuery;
import org.apache.lucene.search.Query;
import org.apache.lucene.search.join.BitSetProducer;
import org.apache.lucene.search.join.ToChildBlockJoinQuery;
import org.elasticsearch.index.query.AbstractQueryBuilder;
import org.elasticsearch.index.query.ParsedQuery;
import org.elasticsearch.index.query.QueryBuilder;
import org.elasticsearch.index.query.SearchExecutionContext;
import org.elasticsearch.index.query.TermsQueryBuilder;
import org.elasticsearch.xcontent.DeprecationHandler;
import org.elasticsearch.xcontent.NamedXContentRegistry;
import org.elasticsearch.xcontent.XContentParser;
import org.elasticsearch.xcontent.json.JsonXContent;

public class DlsQueryParser {
    private static final Logger log = LogManager.getLogger(DlsQueryParser.class);
    private static final Query NON_NESTED_QUERY = new BooleanQuery.Builder().add((Query)new MatchAllDocsQuery(), BooleanClause.Occur.FILTER).add((Query)new PrefixQuery(new Term("_type", "__")), BooleanClause.Occur.MUST_NOT).build();
    private static Cache<String, QueryBuilder> parsedQueryCache = CacheBuilder.newBuilder().maximumSize(10000L).expireAfterWrite(4L, TimeUnit.HOURS).build();
    private static Cache<String, Boolean> queryContainsTlqCache = CacheBuilder.newBuilder().maximumSize(10000L).expireAfterWrite(4L, TimeUnit.HOURS).build();
    private final NamedXContentRegistry namedXContentRegistry;

    public DlsQueryParser(NamedXContentRegistry namedXContentRegistry) {
        this.namedXContentRegistry = namedXContentRegistry;
    }

    public BooleanQuery.Builder parse(Set<String> unparsedDlsQueries, SearchExecutionContext queryShardContext) {
        return this.parse(unparsedDlsQueries, queryShardContext, null);
    }

    public BooleanQuery.Builder parse(Set<String> unparsedDlsQueries, SearchExecutionContext queryShardContext, Function<Query, Query> queryMapFunction) {
        if (unparsedDlsQueries == null || unparsedDlsQueries.isEmpty()) {
            return null;
        }
        boolean hasNestedMapping = queryShardContext.hasNested();
        BooleanQuery.Builder dlsQueryBuilder = new BooleanQuery.Builder();
        dlsQueryBuilder.setMinimumNumberShouldMatch(1);
        for (String unparsedDlsQuery : unparsedDlsQueries) {
            ParsedQuery parsedQuery = queryShardContext.toQuery(this.parse(unparsedDlsQuery));
            Query dlsQuery = parsedQuery.query();
            if (queryMapFunction != null) {
                dlsQuery = queryMapFunction.apply(dlsQuery);
            }
            dlsQueryBuilder.add(dlsQuery, BooleanClause.Occur.SHOULD);
            if (!hasNestedMapping) continue;
            DlsQueryParser.handleNested(queryShardContext, dlsQueryBuilder, dlsQuery);
        }
        return dlsQueryBuilder;
    }

    private static void handleNested(SearchExecutionContext queryShardContext, BooleanQuery.Builder dlsQueryBuilder, Query parentQuery) {
        BitSetProducer parentDocumentsFilter = queryShardContext.bitsetFilter(NON_NESTED_QUERY);
        dlsQueryBuilder.add((Query)new ToChildBlockJoinQuery(parentQuery, parentDocumentsFilter), BooleanClause.Occur.SHOULD);
    }

    public QueryBuilder parse(final String unparsedDlsQuery) {
        try {
            QueryBuilder qb = (QueryBuilder)parsedQueryCache.get((Object)unparsedDlsQuery, (Callable)new Callable<QueryBuilder>(){

                @Override
                public QueryBuilder call() throws Exception {
                    XContentParser parser = JsonXContent.jsonXContent.createParser(DlsQueryParser.this.namedXContentRegistry, DeprecationHandler.THROW_UNSUPPORTED_OPERATION, unparsedDlsQuery);
                    QueryBuilder qb = AbstractQueryBuilder.parseInnerQueryBuilder((XContentParser)parser);
                    return qb;
                }
            });
            return qb;
        }
        catch (UncheckedExecutionException | ExecutionException e) {
            throw new RuntimeException("Error while parsing DLS query: " + unparsedDlsQuery, e.getCause());
        }
    }

    boolean containsTermLookupQuery(Set<String> unparsedQueries) {
        for (String query : unparsedQueries) {
            if (!this.containsTermLookupQuery(query)) continue;
            if (log.isDebugEnabled()) {
                log.debug("containsTermLookupQuery() returns true due to " + query + "\nqueries: " + unparsedQueries);
            }
            return true;
        }
        if (log.isDebugEnabled()) {
            log.debug("containsTermLookupQuery() returns false\nqueries: " + unparsedQueries);
        }
        return false;
    }

    boolean containsTermLookupQuery(String query) {
        try {
            return (Boolean)queryContainsTlqCache.get((Object)query, () -> {
                QueryBuilder queryBuilder = this.parse(query);
                return QueryBuilderTraverser.exists((QueryBuilder)queryBuilder, q -> q instanceof TermsQueryBuilder && ((TermsQueryBuilder)q).termsLookup() != null);
            });
        }
        catch (UncheckedExecutionException | ExecutionException e) {
            throw new RuntimeException("Error while parsing DLS query: " + query, e.getCause());
        }
    }
}

